var menuManager ={
		
	contexMenu:null,

	newHandle: null,
	moreHandle:null,
	sortHandle: null,

	render: null,
	controller:null,  //控制器
	
	itemsText:[
		["打开所有收藏","在新窗口中打开所有收藏"],
		["重命名"],
		["剪切","复制","粘贴"],
		["删除"],
		["新建收藏", "新建文件夹"]
	],
	itemsFuncs: [
		/*
		this.openAll,
		this.openAllInNewWindow,
		this.rename,
		this.cut,
		this.copy,
		this.past,
		this._delete,
		this.add,
		this.newFolder
		*/
	],
	itemsStatus:[
		false,false,
		false,
		false,false,false,
		false,
		false,false
	],
	newHandleText:[
		[
			"新建收藏",
			"新建文件夹"
		]
		//"上传到网络收藏夹"]
	],
	sortHandleText:[
		[
			"按名称",
			"按访问次数",
			"按加入收藏时间"
		]
		//"上传到网络收藏夹"]
	],
	moreHandleText:[
		[],
		[
			"从其他浏览器导入",
			"从HTML导入",
			"从TT网络收藏夹导入"
		],
		["导出HTML"],
		[
			"本地收藏备份到网络",
			"网络收藏下载到本地"
		]
		//"上传到网络收藏夹"]
	],
	moreHandleFuncs:[
		this._import,
		this._export
		//this.load
	],
	init: function(){
		var _this = this;
		this.contexMenu = new qqbrowser.js.widgets.menu("context-menu");
		this.contexMenu.build(this.itemsText);
		
		this.itemsFuncs[0] = bmm.openAll;
		this.itemsFuncs[1] = bmm.openAllInNewWindow;
		this.itemsFuncs[2] = bmm.rename;
		this.itemsFuncs[3] = bmm.cut;
		this.itemsFuncs[4] = bmm.copy;
		this.itemsFuncs[5] = bmm.paste;
		this.itemsFuncs[6] = bmm._delete;
		this.itemsFuncs[7] = bmm.addFav;
		this.itemsFuncs[8] = bmm.newFolder;
		this.contexMenu.funcBind(this.itemsFuncs);
		
		// 解决收藏管理页面header部分的右键菜单响应问题
		var header = $("header")[0];
		header.addEventListener("contextmenu", function(event) {
			menuManager.moreHandle.hide();
			
			event.stopPropagation();
			if (event.target.tagName === "INPUT") { // 如果是input元素，那么使用页面内部input使用的菜单
				return false;
			} else { // 如果不是input元素，那么不出现菜单
				event.returnValue = false;
			}
		}, false);
		
		// contextMenu的事件
		document.addEventListener("contextmenu",function(event){
			menuManager.moreHandle.hide();
			
			menuManager.itemsStatus = [
				false,false,
				false,
				false,false,false,
				false,
				true, true
			];
			
			var clipBoardLength = 0;
			for (var id in clipBoard) {
				++clipBoardLength;
			}
			if(clipBoardLength > 0){
				menuManager.itemsStatus[5] = true;
			}
			
			if (bmm.menuType) {
				bmm.menuType = null;
			}
			
			_this.contexMenu.show(_this.itemsStatus,event);
			event.stopPropagation();
			event.returnValue=false;
		},false);
		
		document.body.appendChild(this.contexMenu._element);
		
		this.moreHandle = new qqbrowser.js.widgets.menu("moreHandleMenu");
		this.moreHandle.build(this.moreHandleText);

		this.newHandle = new qqbrowser.js.widgets.menu('newHandleMenu');
		this.newHandle.build(this.newHandleText);

		this.sortHandle = new qqbrowser.js.widgets.menu('sortHandleMenu');
		this.sortHandle.build(this.sortHandleText);

		// Hard Code by Littleli
		// 原来的代码和css结构设计不好，这里固定的写入sepator的wording和样式
		this.moreHandle._element.children[0].innerHTML = "<span>导入</span>";
		this.moreHandle._element.children[4].innerHTML = "<span>导出</span>";
		this.setSyncWording('未登录');
		this.moreHandle._element.addEventListener('click', function() {
			event.preventDefault();
			event.stopPropagation();
			return false;
		});

		this.moreHandle.funcBind(this.moreHandleFuncs);
		getId("loadMng").appendChild(this.moreHandle._element);
		getId("newFolder").appendChild(this.newHandle._element);
		getId("sortByTitle").appendChild(this.sortHandle._element);

	},


	// 新添接口，登录时设置
	setSyncWording: function(word) {
		// 内容过长的截断判断
		if (word.length >= 9) {
			word = word.slice(0, 9) + '...';
		}
		this.moreHandle._element.children[6].innerHTML = "<span>同步（"+ word +"）</span>";
	},
	
	folderContextMenu: function(_this){
		menuManager.contexMenu.items[0].setTitle("打开所有收藏");
		menuManager.contexMenu.items[1].setTitle("在新窗口中打开所有收藏");
		menuManager.contexMenu.items[2].setTitle("重命名");
		menuManager.itemsStatus = [
			true,true,
			true,
			true,true,false,
			true,
			true, true
		];
		
		if (_this.id == 1) {
			menuManager.itemsStatus[2] = false;
			menuManager.itemsStatus[3] = false;
			menuManager.itemsStatus[4] = false;
			menuManager.itemsStatus[6] = false;
		}

		// 修复当clipBoard为空时的菜单显示逻辑
		if(isEmptyObject(clipBoard) === false && clipBoard[bmm.curTreeItem.id] === undefined){
			menuManager.itemsStatus[5] = true;
		}


		
		// 解决复制或剪切到自身的问题
		//var len = clipBoardLength;
		var flag = false;
		var urlflag = false;
		
		for (var id in clipBoard) {
			// 加入菜单的灰显逻辑
			if (bmm.menuType === "nav") {
				
				// 父文件夹与子孙文件夹的选项判断
				if (clipBoard[id]._element.contains(bmm.curTreeItem._element)) {
					flag = true;
					break;
				} 
			
				if (clipBoard[id].id === bmm.curTreeID || clipBoard[id]._root.id === bmm.curTreeID) {
					flag = true;
					break;
				}
			} else if (bmm.menuType === "content") {
				if (clipBoard[id].id === bmm.curListID || clipBoard[id]._root.id === bmm.curListID) {
					flag = true;
					break;
				}
				// Modified by littleli
				// 如果当前是搜索结果，那么最后两项灰显
				if (bmm.isSearch) {
					menuManager.itemsStatus[7] = false;
					menuManager.itemsStatus[8] = false;
				}
			}
		}
		
		// 空文件夹的菜单头两项灰显逻辑
		var openFlag = false;
		if (bmm.menuType === "nav") { // 如果是左侧导航区，那么直接判断bmm.curTreeItem的属性
			if (bmm.curTreeItem.mayhaveChildren && bmm.curTreeItem.hasUrlChildren) {
				openFlag = true;
			}
		} else if (bmm.menuType === "content") { // 右侧导航区需要解决单选右键的情况
			for (var id in itemsChosed) {
				var item = itemsChosed[id].treeitem;
				if (item && item.mayhaveChildren && item.hasUrlChildren) {
					openFlag = true;
					break;
				}
			}
		}
		
		if (openFlag) {
			menuManager.itemsStatus[0] = true;
			menuManager.itemsStatus[1] = true;
		} else {
			menuManager.itemsStatus[0] = false;
			menuManager.itemsStatus[1] = false;
		}

		
		if(flag) {
			menuManager.itemsStatus[5] = false;
		}
		
		// Modified by littleli
		// 右侧内容区域选中多个选项后置灰5项内容
		var itemsChosedLength = 0;
		for (var id in itemsChosed) {
			++itemsChosedLength;
		}
		if(itemsChosedLength > 1) {
			menuManager.itemsStatus[0] = false;
			menuManager.itemsStatus[1] = false;
			menuManager.itemsStatus[2] = false;
			menuManager.itemsStatus[7] = false;
			menuManager.itemsStatus[8] = false;
		}
		
		// 标识当前menu所属的类型
		menuManager.contexMenu.show(menuManager.itemsStatus,event);
	},
	
	urlContextMenu: function(_this){
		menuManager.contexMenu.items[0].setTitle("在新标签页中打开");
		menuManager.contexMenu.items[1].setTitle("在新窗口中打开");
		menuManager.contexMenu.items[2].setTitle("编辑");
		menuManager.itemsStatus = [
			true,true,
			true,
			true,true,false,
			true,
			true, true
		];

		var itemsChosedLength = 0;
		for (var id in itemsChosed) {
			++itemsChosedLength;
		}
		if(itemsChosedLength > 1) {
			menuManager.itemsStatus[2] = false;
		}
		
		var clipBoardLength = 0;
		for (var id in clipBoard) {
			++clipBoardLength;
		}
		if (clipBoardLength > 0 ) {
			menuManager.itemsStatus[5] = true;
		}
		
		// Modified by littleli
		// 如果当前是搜索结果，那么最后两项灰显
		if (bmm.isSearch) {
			menuManager.itemsStatus[7] = false;
			menuManager.itemsStatus[8] = false;
		}
	
		
		menuManager.contexMenu.show(menuManager.itemsStatus,event);
	}
};
